#version 140
#extension GL_EXT_gpu_shader4 : enable
//Simple bubblesMod01.fsh
//https://www.shadertoy.com/view/flf3Rj
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed* 0.666
#define iResolution u_WindowSize

#define iMouse AUTO_MOUSE
#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define iMouse vec4(0.0,0.0, 0.0,0.0)
#ifdef GL_ES
precision mediump float;
#endif
vec4 texture2D_Fract(sampler2D sampler,vec2 P)
 { return texture2D(sampler,fract(P));
 }
uniform sampler2D iChannel0;

#define sat(a) clamp(a, 0., 1.)

vec2 _min(vec2 a, vec2 b)
{
    if (a.x < b.x)
        return a;
    return b;
}

vec2 map(vec3 p)
{
    vec2 acc = vec2(1000.,-1.);
    for (int i = 0; i < 10; ++i)
    {
        float fi = float(i)+iTime*0.0025;
        vec3 pos = p - vec3(sin(fi+iTime*.5), cos(fi*5.), cos(fi))*sin(fi*3.)*7.;
        float sz = .5+.2*sin(fi);
        acc = _min(acc, vec2(length(pos)-sz,0.));
    }
    for (int i = 0; i < 10; ++i)
    {
        float fi = float(i)+10.+iTime*.01;
        vec3 pos = p - vec3(sin(fi+iTime*fi*.01), cos(fi*5.), cos(fi))*sin(fi*3.)*7.;
        float sz = .05+.025*sin(fi);
        acc = _min(acc, vec2(length(pos)-sz,1.));
    }
    return acc;
}

vec3 trace(vec3 ro, vec3 rd, int steps)
{
    vec3 p = ro;
    for (int i = 0; i < steps; ++i)
    {
        vec2 res = map(p);
        if (res.x < 0.01)
            return vec3(res.x, distance(p, ro), res.y);
        p += rd * res.x;
    }
    return vec3(-1.);
}

vec3 getCam(vec3 rd, vec2 uv)
{
    vec3 r = normalize(cross(rd, vec3(0.,1.,0.)));
    vec3 u = normalize(cross(rd, r));
    return normalize(rd+(r*uv.x+u*uv.y)*3.);
}

vec3 getNorm(vec3 p, float d)
{
    vec2 e = vec2(0.01,0.);
    return normalize(vec3(d)-vec3(map(p-e.xyy).x, map(p-e.yxy).x, map(p-e.yyx).x));
}

vec3 dordr(vec3 ro, vec3 rd)
{
    vec3 col = mix(vec3(1.000,0.000,0.349),vec3(.1), pow(sat(2.*abs(dot(rd, vec3(0.,1.,0.)))),.5));
    vec3 res = trace(ro, rd, 32);
    if (res.y > 0.)
    {
        vec3 p = ro+rd*res.y;
        vec3 n = getNorm(p, res.x);
        col = (n *.5+.5);
        if (res.z == 0.)
            col = mix(vec3(1.000,0.000,0.349),vec3(.1,.1,.15), 1.-pow(sat(abs(dot(vec3(0.,1.,0.), n))),2.));
        else
            col = mix(vec3(0.094,0.969,0.471),vec3(.1,.1,.15), clamp(sin(n.y*10.),-1.,1.));
        col = mix(vec3(0.05,0.1,0.2), col, 1.-sat(exp(-res.y*0.1)));
    }
    return col;
}

vec3 rdr2d(vec2 uv)
{
    float t = iTime*.5;
    float d = 7.;
    vec3 ro = vec3(sin(t)*d,0.,cos(t)*d);
    vec3 ta = vec3(0.,0.,0.);
    vec3 rd = normalize(ta-ro);
    rd = getCam(rd, uv);
    vec3 col = dordr(ro, rd);
    return col;
}

void mainVR( out vec4 gl_FragColor, in vec2 gl_FragCoord, in vec3 fragRayOri, in vec3 fragRayDir )
{
    vec3 col =dordr(fragRayOri,fragRayDir);
    
    gl_FragColor = vec4(col,1.0);
}
void main(void)
//void mainImage( out vec4 gl_FragColor, in vec2 gl_FragCoord )
{
    vec2 uv = (gl_FragCoord.xy-vec2(.5)*iResolution.xy)/iResolution.xx;

    vec3 col =rdr2d(uv);
    
    gl_FragColor = vec4(col,1.0);
}






